;PIC16F873 Monopoly Banker v1.06H
;This version reverses LCD data out pins to allow for LCD mounting on top of PCB
;It also reverses E and RS pins to simplify PCB layout and uses 3 column output to keypad
;
;Notes
;
;Four pages - sit RP0 and RP1 accordingly in STATUS register
;
;Following is a full list of register equates, with STATUS pages-delete as necessary;
;
;
INDF:    .EQU $00  ;page 0, 1, 2, 3
TMR0:    .EQU $01  ;page 0, 2
OPTION:  .EQU $01  ;page 1, 3
PCL:     .EQU $02  ;page 0, 1, 2, 3
STATUS:  .EQU $03  ;page 0, 1, 2, 3
FSR:     .EQU $04  ;page 0, 1, 2, 3

PORTA:   .EQU $05  ;page 0
TRISA:   .EQU $05  ;page 1
PORTB:   .EQU $06  ;page 0, 2
TRISB:   .EQU $06  ;page 1, 3
PORTC:   .EQU $07  ;page 0
TRISC:   .EQU $07  ;page 1
PORTD:   .EQU $08  ;page 0
TRISD:   .EQU $08  ;page 1
PORTE:   .EQU $09  ;page 0
TRISE:   .EQU $09  ;page 1

PCLATH:  .EQU $0A  ;page 0, 1, 2, 3
INTCON:  .EQU $0B  ;page 0, 1, 2, 3

PIR1:    .EQU $0C  ;page 0
PIE1:    .EQU $0C  ;page 1
EEDATA:  .EQU $0C  ;page 2
EECON1:  .EQU $0C  ;page 3
         
PIR2:    .EQU $0D  ;page 0
PIE2:    .EQU $0D  ;page 1
EEADR:   .EQU $0D  ;page 2
EECON2:  .EQU $0D  ;page 3

TMR1L:   .EQU $0E  ;page 0
PCON:    .EQU $0E  ;page 1
EEDATH:  .EQU $0E  ;page 2

TMR1H:   .EQU $0F  ;page 0
EEADRH:  .EQU $0F  ;page 2

T1CON :  .EQU $10  ;page 0

TMR2:    .EQU $11  ;page 0
SSPCON2: .EQU $11  ;page 1

T2CON:   .EQU $12  ;page 0
PR2:     .EQU $12  ;page 1

SSPBUF:  .EQU $13  ;page 0
SSPADD:  .EQU $13  ;page 1

SSPCON:  .EQU $14  ;page 0
SSPSTAT: .EQU $14  ;page 1

CCPR1L:  .EQU $15  ;page 0
CCPR1H:  .EQU $16  ;page 0
CCP1CON: .EQU $17  ;page 0

RCSTA:   .EQU $18  ;page 0
TXSTA:   .EQU $18  ;page 1

TXREG:   .EQU $19  ;page 0
SPBRG:   .EQU $19  ;page 1

RCREG:   .EQU $1A  ;page 0
CCPR2L:  .EQU $1B  ;page 0
CCPR2H:  .EQU $1C  ;page 0
CCP2CON: .EQU $1D  ;page 0

ADRESH:  .EQU $1E  ;page 0
ADRESL:  .EQU $1E  ;page 1

ADCON0:  .EQU $1F  ;page 0
ADCON1:  .EQU $1F  ;page 1

w:	 .EQU $00  ;page 0

LCDOUT	.EQU $20   ;page 0 - LCD DRIVER - holds data to be sent to module
LCDWKG	.EQU $21   ;page 0 - LCD DRIVER - holds temporary data within timing section
LCDCHR	.EQU $22   ;page 0 - LCD DRIVER - holds number of characters left on a line
COUNT	.EQU $23   ;page 0 - general counter
FLAG	.EQU $24   ;page 0 - general flag
CURSOR	.EQU $25   ;page 0 - LCD cursor position
DIGU	.EQU $26   ;page 0 - used in binary conversion	
DIGT	.EQU $27   ;page 0 - used in binary conversion
PSID	.EQU $28   ;page 0 - sets station ID	
HDR1	.EQU $29   ;page 0 - data header byte
HDR2	.EQU $2A   ;page 0 - data header byte
BALH	.EQU $2B   ;page 0 - account balance high byte **TEMP**
BALL	.EQU $2C   ;page 0 - account balance low byte **TEMP**

BYTE1	.EQU $2D   ;page 0 - input byte 1
BYTE2	.EQU $2E   ;page 0 - input byte 2
BYTE3	.EQU $2F   ;page 0 - input byte 3
BYTE4	.EQU $30   ;page 0 - input byte 4
BYTE5	.EQU $31   ;page 0 - input byte 5
BYTE6	.EQU $32   ;page 0 - input byte 6
BYTETMP .EQU $35   ;page 0 - input byte temp

D0	.EQU $36   ;page 0 - Binary to Decimal routine
D1	.EQU $37   ;page 0 - Binary to Decimal routine
D2	.EQU $38   ;page 0 - Binary to Decimal routine
D3	.EQU $39   ;page 0 - Binary to Decimal routine
D4	.EQU $3A   ;page 0 - Binary to Decimal routine
NUMHI	.EQU $3B   ;page 0 - Binary to Decimal routine
NUMLO	.EQU $3C   ;page 0 - Binary to Decimal routine
LASTID	.EQU $3D   ;page 0 - last transaction other station ID
LTHI	.EQU $3E   ;page 0 - last transaction high byte
LTLO	.EQU $3F   ;page 0 - last transaction low byte

KEYFLG	.EQU $40   ;PAGE 0 - keeps track of transaction entering process
KEYDAT	.EQU $41   ;page 0 - keyboard button
NEWID	.EQU $42   ;page 0 - 
NEWAM	.EQU $43   ;page 0 - 
NEWAMFH	.EQU $44   ;page 0 - 
NEWAMFL	.EQU $45   ;page 0 - 
NEWAMTH	.EQU $46   ;page 0 - 
NEWAMTL	.EQU $47   ;page 0 - 

HDR3	.EQU $48   ;page 0 - data header byte - sending
HDR4	.EQU $49   ;page 0 - data header byte - sending
CLKOUT  .EQU $50   ;page 0 - clocking out variable
CLKSND	.EQU $51   ;page 0 - ready to send flag
PLAY0L	.EQU $52   ;page 0 - account balance storage
PLAY1L	.EQU $53   ;page 0 - account balance storage
PLAY2L	.EQU $54   ;page 0 - account balance storage
PLAY3L	.EQU $55   ;page 0 - account balance storage
PLAY4L	.EQU $56   ;page 0 - account balance storage
PLAY0H	.EQU $57   ;page 0 - account balance storage
PLAY1H	.EQU $58   ;page 0 - account balance storage
PLAY2H	.EQU $59   ;page 0 - account balance storage
PLAY3H	.EQU $5A   ;page 0 - account balance storage
PLAY4H	.EQU $5B   ;page 0 - account balance storage
SMLC	.EQU $5C   ;page 0 - Send Manager Loop Counter
SMPC	.EQU $5D   ;page 0 - Send Manager Player Counter

		.org 4
		.org 5

;-------SETUP ROUTINE--------------------------
	BSF STATUS,5
	BCF STATUS,6	;SETS PAGE 01
	movlw %00000111
	movwf ADCON1	;set inputs as digital
	clrf TRISA
	bsf PORTA,1
	bsf PORTA,2
	bsf PORTA,3
	bsf PORTA,4
	CLRF TRISB
	bsf PORTB,6	;set unused PORT bits as inputs
	bsf PORTB,7
	CLRF TRISC	;set all Port C as output
	bsf PORTC,5	;set these two bits as inputs
	bsf PORTC,4
	movlw %10000110 ;move literal value into W (binary shown intentionally)
        movwf OPTION    ;set into OPTION; 
	BCF STATUS,5	;SETS PAGE 00
	clrf PORTA
	clrf PORTB
	clrf PORTC
	clrf LCDOUT
	clrf LCDWKG
	clrf LCDCHR
	clrf COUNT
	clrf FLAG
	clrf CURSOR
	clrf DIGU
	clrf DIGT
	clrf PSID
	clrf HDR1
	clrf HDR2
	clrf BALH
	clrf BALL
	clrf BYTE1
	clrf BYTE2
	clrf BYTE3
	clrf BYTE4
	clrf BYTE5
	clrf BYTE6
	clrf BYTETMP
	clrf D0
	clrf D1
	clrf D2
	clrf D3
	clrf D4
	clrf NUMHI
	clrf NUMLO
	clrf LASTID
	clrf LTHI
	clrf LTLO
	clrf KEYFLG
	clrf KEYDAT
	clrf NEWID
	clrf NEWAM
	clrf NEWAMFH
	clrf NEWAMFL
	clrf NEWAMTH
	clrf NEWAMTL
	clrf HDR3
	clrf HDR4
	clrf CLKOUT
	clrf CLKSND
	movlw %11011100
	movwf PLAY0L
	movwf PLAY1L
	movwf PLAY2L
	movwf PLAY3L
	movwf PLAY4L
	movlw %00000101
	movwf PLAY0H
	movwf PLAY1H
	movwf PLAY2H
	movwf PLAY3H
	movwf PLAY4H
	clrf SMLC
	clrf SMPC
	movlw %00000000	;sets station ID - zero, since this is the Banker
	movwf PSID
	movlw %11000011	;set up initial account balances
	movwf PLAY0H
	movlw %01010000
	movwf PLAY0L
	call XINIT

;Pin Assignments

;Port B,0 output	LCD Module D4 input
;Port B,1 output	LCD Module D5 input
;Port B,2 output	LCD Module D6 input
;Port B,3 output	LCD Module D7 input
;Port B,4 output	LCD Module E input
;Port B,5 output	LCD Module RS input
;Port B,6 input		spare
;Port B,7 input		spare
;Port A,1 input		Keypad Row 1
;Port A,2 input		Keypad Row 2
;Port A,3 input		Keypad Row 3
;Port A,4 input		Keypad Row 4
;Port C,0 output	Keypad Column 1
;Port C,1 output	Keypad Column 2
;Port C,2 output	Keypad Column 3
;Port C,7 output	Bank data - CLOCK
;Port C,6 output	Bank data - DATA
;Port C,5 input		PS data - CLOCK
;Port C,4 input		PS data - DATA


	;set up preset data
	movlw %11111111
	movwf HDR1
	movlw %00011100
	movwf HDR2

	call MSGA
	call MSGB
	call BEEP

	call ENDTR;initial balance display

LP:	CALL sndmgr
	clrf TMR0
LSTLP:	btfss PORTC,5
	CALL listen
	btfss TMR0,2
	goto LSTLP
	call KEYPD
	btfsc KEYDAT,7	;check for keypress
	call KEYPRC

	goto LP

;--------------------RECEIVE SERIAL DATA, CHECK VALIDITY AND PROCESS------------------------

;-------RECEIVE DATA AND STACK IT IN VARIABLES

listen:	;------there are 6 bytes of data to recieve, which 6 x 8 = 48 clock cycles
	;the variable CLKOUT has a second use here!
	movlw %00110000
	movwf CLKOUT


getd:	clrf TMR0
	bcf STATUS,2
	btfss PORTC,4
	bsf BYTETMP,1
	rrf BYTE6,1	;effect software "shift register"
	rrf BYTE5,1
	rrf BYTE4,1
	rrf BYTE3,1
	rrf BYTE2,1
	rrf BYTE1,1	;rotate right. LSB "falls off the edge" and is lost
	bcf BYTE6,7	;ensure the MSB of BYTE8 is clear, to be set if required by the next couple of lines
	btfsc BYTETMP,1	;but set it if data pin was high
	bsf BYTE6,7
	clrf BYTETMP
Iwait:	btfsc TMR0,7	;time limit to protect against comms failure
	RETURN
	btfss PORTC,5	;wait for clock to go back to set(i.e.) logical low, hardware high
	goto Iwait
Iwait1:	btfsc TMR0,7	;time limit to protect against comms failure
	RETURN
	btfsc PORTC,5	;wait for next logical high/hardware low
	goto Iwait1
	decfsz CLKOUT,1	;decrement data bit counter but skip/escape if there have been enough cycles
	goto getd
	CALL CDATA
	RETURN

;-------VERIFY RECEIVED DATA AND PROCESS IF OK

CDATA:	movlw %11111111
	bcf STATUS,2	;clear Z flag
	xorwf BYTE1,0	;check to see if it matches expected header
	btfss STATUS,2	;if Z is set, which indicates %11111111 has been recieved, so routine should not return
	RETURN

	movlw %00011100
	bcf STATUS,2	;clear Z flag
	xorwf BYTE2,0	;check to see if it matches expected header
	btfss STATUS,2	;if Z is set, which indicates %00011100 has been recieved, so routine should not return
	RETURN

	movf BYTE3,0	;since routine reaches here, headers must match, so update
	movwf SMPC
	movf BYTE4,0	;since routine reaches here, headers must match, so update
	movwf NEWAMFH
	movf BYTE5,0
	movwf NEWAMFL
	movf BYTE6,0	;since routine reaches here, headers must match, so update
	movwf NEWID
	CALL XNUM
	clrf BYTE1	;clear all input data bytes to ensure there is no false matching
	clrf BYTE2
	clrf BYTE3
	clrf BYTE4
	clrf BYTE5
	clrf BYTE6
	call TRSEND

	RETURN

;------------------SUBROUTINES FOR SENDNG DATA FROM BANKER TO PLAYERS

BNKSND: call BNKSER
	call BNKSER
	call BNKSER
	call BNKSER
	call BNKSER
	call BNKSER
	call BNKSER
	call BNKSER
	RETURN

BNKSER:	bcf PORTC,7	;clear serial output pins
	bcf PORTC,6
	;CALL DLY
	CALL DLY
	btfsc CLKOUT,0	;test LSB bit and set output pin accordingly
	bsf PORTC,6
	bsf PORTC,7	;clock out
	CALL DLY
	bcf PORTC,7
	;CALL DLY
	CALL DLY
	rrf CLKOUT,1	;rotate right
	RETURN

;------------KEYPAD ENTRY AND PREPARATION OF DATA FOR SENDING TO PLAYER------------------------


SNDMGR: incf SMLC,1
	btfss SMLC,4	;ensures that X loops have to take place before next PS data is sent(gives time for return data)
	RETURN


;-------now send next player station data
	clrf SMLC
	incf SMPC,1
	movlw %00000101
	bcf STATUS,2
	xorwf SMPC,0	;check to see if illegal PSID has been reached
	btfss STATUS,2	;if Z is set, result of XORWF is non-match, so skip to sending
	goto SM1	
	movlw %00000001	;but if Z was not set, reset to Player Station number 1
	movwf SMPC
SM1:	movf HDR1,0
	movwf CLKOUT
	CALL BNKSND
	movf HDR2,0
	movwf CLKOUT
	CALL BNKSND
	movf SMPC,0	;send PSID
	movwf CLKOUT
	CALL BNKSND

	bcf STATUS,2
	movlw %00000001
	xorwf SMPC,0	;check to see if PS1 data to be sent
	btfsc STATUS,2	;if Z is set, result of XORWF is non-match, so skip
	CALL PS1

	bcf STATUS,2
	movlw %00000010
	xorwf SMPC,0	;check to see if PS2 data to be sent
	btfsc STATUS,2	;if Z is set, result of XORWF is non-match, so skip
	CALL PS2

	bcf STATUS,2
	movlw %00000011
	xorwf SMPC,0	;check to see if PS3 data to be sent
	btfsc STATUS,2	;if Z is set, result of XORWF is non-match, so skip
	CALL PS3

	bcf STATUS,2
	movlw %00000100
	xorwf SMPC,0	;check to see if PS4 data to be sent
	btfsc STATUS,2	;if Z is set, result of XORWF is non-match, so skip
	CALL PS4

	movf LASTID,0
	movwf CLKOUT
	call BNKSND

	movf LTHI,0
	movwf CLKOUT
	call BNKSND

	movf LTLO,0
	movwf CLKOUT
	call BNKSND

	RETURN

PS1:	movf PLAY1H,0
	movwf CLKOUT
	CALL BNKSND
	movf PLAY1L,0
	movwf CLKOUT
	CALL BNKSND
	RETURN

PS2:	movf PLAY2H,0
	movwf CLKOUT
	CALL BNKSND
	movf PLAY2L,0
	movwf CLKOUT
	CALL BNKSND
	RETURN

PS3:	movf PLAY3H,0
	movwf CLKOUT
	CALL BNKSND
	movf PLAY3L,0
	movwf CLKOUT
	CALL BNKSND
	RETURN

PS4:	movf PLAY4H,0
	movwf CLKOUT
	CALL BNKSND
	movf PLAY4L,0
	movwf CLKOUT
	CALL BNKSND
	RETURN

;-------KEYPAD INTERPRETER

;Port A,1 input		Keypad Row 1
;Port A,2 input		Keypad Row 2
;Port A,3 input		Keypad Row 3
;Port A,4 input		Keypad Row 4
;Port C,0 output	Keypad Column 1
;Port C,1 output	Keypad Column 2
;Port C,2 output	Keypad Column 3

KEYPD:	;check column 1 of keypad
	bcf PORTC,1
	bcf PORTC,2
	bsf PORTC,0
	btfss PORTA,1
	goto c1b
	movlw %10000001
	movwf KEYDAT
	goto rowrd
c1b:	btfss PORTA,2
	goto c1c
	movlw %10000100
	movwf KEYDAT
	goto rowrd
c1c:	btfss PORTA,3
	goto c1d
	movlw %10000111
	movwf KEYDAT
	goto rowrd
c1d:	btfss PORTA,4
	goto c2a
	movlw %10101010
	movwf KEYDAT
	goto rowrd

c2a:	;check column 2 of keypad
	bcf PORTC,0
	bcf PORTC,2
	bsf PORTC,1
	btfss PORTA,1
	goto c2b
	movlw %10000010
	movwf KEYDAT
	goto rowrd
c2b:	btfss PORTA,2
	goto c2c
	movlw %10000101
	movwf KEYDAT
	goto rowrd
c2c:	btfss PORTA,3
	goto c2d
	movlw %10001000
	movwf KEYDAT
	goto rowrd
c2d:	btfss PORTA,4
	goto c3a
	movlw %10000000
	movwf KEYDAT
	goto rowrd

c3a:	;check column 3 of keypad
	bcf PORTC,0
	bcf PORTC,1
	bsf PORTC,2
	btfss PORTA,1
	goto c3b
	movlw %10000011
	movwf KEYDAT
	goto rowrd
c3b:	btfss PORTA,2
	goto c3c
	movlw %10000110
	movwf KEYDAT
	goto rowrd
c3c:	btfss PORTA,3
	goto c3d
	movlw %10001001
	movwf KEYDAT
	goto rowrd
c3d:	btfss PORTA,4
	goto rowrd	;kept only for clarity
	movlw %10100011
	movwf KEYDAT
	goto rowrd

rowrd:	bcf PORTC,2
	btfss KEYDAT,7
	RETURN
	call BEEP
	movlw %01111111
	movwf KEYFLG
KEYDLY:	call p10ms
	decfsz KEYFLG,1
	goto KEYDLY
	RETURN

KEYPRC:	clrf NEWAMFH
	clrf NEWAMFL
	bcf KEYDAT,7	;clear keypress flag
	movlw %00100011
	bcf STATUS,2	;clear Z bit
	xorwf KEYDAT,0	;check to see if it matches enter key #
	btfss STATUS,2	;if Z is set, result of XORWF is zero = non-match, so subroutine returns, but if clear skips to next 
	RETURN
	call MSG3	;change screen text
	call MSG4
	movlw %01000110	;move cursor on LCD to correct position for station ID
	movwf cursor
	CALL XCUR
k12:	call KEYPD
	btfss KEYDAT,7
	goto k12
	bcf KEYDAT,7	;clear keypress flag
	movlw %00101010
	bcf STATUS,2	;clear Z bit
	xorwf KEYDAT,0	;check to see if it matches escape key *
	btfsc STATUS,2	;if Z is set, result of XORWF is zero = non-match, so subroutine returns, but if clear skips to next 
	goto ENDTR
	movlw %00100011
	xorwf KEYDAT,0	;check to see if it matches escape key *
	btfsc STATUS,2	;if Z is set, result of XORWF is zero = non-match, so subroutine returns, but if clear skips to next 
	goto ENDTR

	movlw %00000000
	xorwf KEYDAT,0	;check to see if it matches a valid station ID
	btfsc STATUS,2	;if Z is set, result of XORWF is zero = non-match, so subroutine returns, but if clear skips to next 
	goto K12a

	movlw %00000001
	xorwf KEYDAT,0	;check to see if it matches a valid station ID
	btfsc STATUS,2	;if Z is set, result of XORWF is zero = non-match, so subroutine returns, but if clear skips to next 
	goto K12a

	movlw %00000010
	xorwf KEYDAT,0	;check to see if it matches a valid station ID
	btfsc STATUS,2	;if Z is set, result of XORWF is zero = non-match, so subroutine returns, but if clear skips to next 
	goto K12a

	movlw %00000011
	xorwf KEYDAT,0	;check to see if it matches a valid station ID
	btfsc STATUS,2	;if Z is set, result of XORWF is zero = non-match, so subroutine returns, but if clear skips to next 
	goto K12a

	movlw %00000100
	xorwf KEYDAT,0	;check to see if it matches a valid station ID
	btfsc STATUS,2	;if Z is set, result of XORWF is zero = non-match, so subroutine returns, but if clear skips to next 
	goto K12a

	goto k12

k12a:	movf KEYDAT,0
	movwf NEWID
	CALL XNUM

	movlw %01001011	;move cursor on LCD to correct position for transaction amount
	movwf cursor
	CALL XCUR

k13:	call KEYPD
	btfss KEYDAT,7
	goto k13
	bcf KEYDAT,7	;clear keypress flag
	movlw %00101010
	bcf STATUS,2	;clear Z bit
	xorwf KEYDAT,0	;check to see if it matches escape key *
	btfsc STATUS,2	;if Z is set, result of XORWF is zero = non-match, so subroutine returns, but if clear skips to next 
	goto ENDTR
	movlw %00100011
	xorwf KEYDAT,0	;check to see if it matches escape key #
	btfsc STATUS,2	;if Z is set, result of XORWF is zero = non-match, so subroutine returns, but if clear skips to next 
	goto ENDTR	;IN THIS CASE ONLY the send option is disabled, since there is no transaction value. # just cancels.


	movf KEYDAT,0
	movwf NEWAM
	call Tadd
	call XNUM

k14:	call KEYPD
	btfss KEYDAT,7
	goto k14
	bcf KEYDAT,7	;clear keypress flag
	movlw %00101010
	bcf STATUS,2	;clear Z bit
	xorwf KEYDAT,0	;check to see if it matches escape key *
	btfsc STATUS,2	;if Z is set, result of XORWF is zero = non-match, so subroutine returns, but if clear skips to next 
	goto ENDTR
	movlw %00100011
	xorwf KEYDAT,0	;check to see if it matches enter key #
	btfsc STATUS,2	;if Z is set, result of XORWF is zero = non-match, so subroutine returns, but if clear skips to next 
	goto ENDSN

	call TxTEN	;multiply previous stored result by ten
	movf KEYDAT,0
	movwf NEWAM
	call Tadd
	call XNUM

k15:	call KEYPD
	btfss KEYDAT,7
	goto k15
	bcf KEYDAT,7	;clear keypress flag
	movlw %00101010
	bcf STATUS,2	;clear Z bit
	xorwf KEYDAT,0	;check to see if it matches escape key *
	btfsc STATUS,2	;if Z is set, result of XORWF is zero = non-match, so subroutine returns, but if clear skips to next 
	goto ENDTR
	movlw %00100011
	xorwf KEYDAT,0	;check to see if it matches enter key #
	btfsc STATUS,2	;if Z is set, result of XORWF is zero = non-match, so subroutine returns, but if clear skips to next 
	goto ENDSN

	call TxTEN	;multiply previous stored result by ten
	movf KEYDAT,0
	movwf NEWAM
	call Tadd
	call XNUM

k16:	call KEYPD
	btfss KEYDAT,7
	goto k16
	bcf KEYDAT,7	;clear keypress flag
	movlw %00101010
	bcf STATUS,2	;clear Z bit
	xorwf KEYDAT,0	;check to see if it matches escape key *
	btfsc STATUS,2	;if Z is set, result of XORWF is zero = non-match, so subroutine returns, but if clear skips to next 
	goto ENDTR
	movlw %00100011
	xorwf KEYDAT,0	;check to see if it matches enter key #
	btfsc STATUS,2	;if Z is set, result of XORWF is zero = non-match, so subroutine returns, but if clear skips to next 
	goto ENDSN

	call TxTEN	;multiply previous stored result by ten
	movf KEYDAT,0
	movwf NEWAM
	call Tadd
	call XNUM

k17:	call KEYPD
	btfss KEYDAT,7
	goto k17
	bcf KEYDAT,7	;clear keypress flag
	movlw %00101010
	bcf STATUS,2	;clear Z bit
	xorwf KEYDAT,0	;check to see if it matches escape key *
	btfsc STATUS,2	;if Z is set, result of XORWF is zero = non-match, so subroutine returns, but if clear skips to next 
	goto ENDTR
	movlw %00100011
	xorwf KEYDAT,0	;check to see if it matches enter key #
	btfsc STATUS,2	;if Z is set, result of XORWF is zero = non-match, so subroutine returns, but if clear skips to next 
	goto ENDSN

	call TxTEN	;multiply previous stored result by ten
	movf KEYDAT,0
	movwf NEWAM
	call Tadd
	call XNUM

k18:	call KEYPD
	btfss KEYDAT,7
	goto k18
	bcf KEYDAT,7	;clear keypress flag
	movlw %00101010
	bcf STATUS,2	;clear Z bit
	xorwf KEYDAT,0	;check to see if it matches escape key *
	btfsc STATUS,2	;if Z is set, result of XORWF is zero = non-match, so subroutine returns, but if clear skips to next 
	goto ENDTR
	movlw %00100011
	xorwf KEYDAT,0	;check to see if it matches enter key #
	btfsc STATUS,2	;if Z is set, result of XORWF is zero = non-match, so subroutine returns, but if clear skips to next 
	goto ENDSN
	goto k18	;do not proceed without either a # or a *

ENDSN:	movf PSID,0	;make SMPC equal to PSID
	movwf SMPC
	bsf CLKSND,0

TRSEND:	bcf CLKSND,0
	;NEWAMFH AND NEWAMFL should have the transaction value
	;NEWID is the destination ID, so NEWAMFH/L adds to the relevant PLAY(x)H/L
	;SMPC is the source ID, so PLAY(y)H/L is reduced by NEWAMFH/L
	bcf STATUS,2
	movlw %00000000
	xorwf SMPC,0	;check to see if PS0 data to be sent
	btfsc STATUS,2	;if Z is set, result of XORWF is non-match, so skip
	CALL sub0

	bcf STATUS,2
	movlw %00000001
	xorwf SMPC,0	;check to see if PS1 data to be sent
	btfsc STATUS,2	;if Z is set, result of XORWF is non-match, so skip
	CALL sub1

	bcf STATUS,2
	movlw %00000010
	xorwf SMPC,0	;check to see if PS2 data to be sent
	btfsc STATUS,2	;if Z is set, result of XORWF is non-match, so skip
	CALL sub2

	bcf STATUS,2
	movlw %00000011
	xorwf SMPC,0	;check to see if PS3 data to be sent
	btfsc STATUS,2	;if Z is set, result of XORWF is non-match, so skip
	CALL sub3

	bcf STATUS,2
	movlw %00000100
	xorwf SMPC,0	;check to see if PS4 data to be sent
	btfsc STATUS,2	;if Z is set, result of XORWF is non-match, so skip
	CALL sub4

	bcf STATUS,2
	movlw %00000000
	xorwf NEWID,0	;check to see if PS0 data to be sent
	btfsc STATUS,2	;if Z is set, result of XORWF is non-match, so skip
	CALL add0

	bcf STATUS,2
	movlw %00000001
	xorwf NEWID,0	;check to see if PS1 data to be sent
	btfsc STATUS,2	;if Z is set, result of XORWF is non-match, so skip
	CALL add1

	bcf STATUS,2
	movlw %00000010
	xorwf NEWID,0	;check to see if PS2 data to be sent
	btfsc STATUS,2	;if Z is set, result of XORWF is non-match, so skip
	CALL add2

	bcf STATUS,2
	movlw %00000011
	xorwf NEWID,0	;check to see if PS3 data to be sent
	btfsc STATUS,2	;if Z is set, result of XORWF is non-match, so skip
	CALL add3

	bcf STATUS,2
	movlw %00000100
	xorwf NEWID,0	;check to see if PS4 data to be sent
	btfsc STATUS,2	;if Z is set, result of XORWF is non-match, so skip
	CALL add4

	movf NEWAMFH,0	;update last transaction stats
	movwf LTHI
	movf NEWAMFL,0
	movwf LTLO
	movf NEWID,0
	movwf LASTID


ENDTR:	call MSG1
	call MSG2
;-------update reserve balance display
	movf PLAY0H,0
	movwf NUMHI
	movf PLAY0L,0
	movwf NUMLO
	CALL B2DF
	movlw %00001011	;move cursor on LCD to correct position for reserve display
	movwf cursor
	CALL XCUR
	movf D4,0	;move to working register and call routine to display number
	call XNUM
	movf D3,0	;move to working register and call routine to display number
	CALL XNUM
	movf D2,0	;move to working register and call routine to display number
	CALL XNUM
	movf D1,0	;move to working register and call routine to display number
	CALL XNUM
	movf D0,0	;move to working register and call routine to display number
	CALL XNUM
;-------update last transaction display
	movlw %01000111	;move cursor on LCD to correct position for last station ID
	movwf cursor
	CALL XCUR
	movf LASTID,0
	CALL XNUM
	movF LTHI,0
	movwf NUMHI
	movf LTLO,0
	movwf NUMLO
	CALL B2DF
	movlw %01001011	;move cursor on LCD to correct position for transaction amount
	movwf cursor
	CALL XCUR
	movf D4,0	;move to working register and call routine to display number
	call XNUM
	movf D3,0	;move to working register and call routine to display number
	CALL XNUM
	movf D2,0	;move to working register and call routine to display number
	CALL XNUM
	movf D1,0	;move to working register and call routine to display number
	CALL XNUM
	movf D0,0	;move to working register and call routine to display number
	CALL XNUM
	RETURN

TRCHK:	movf PLAY0H,0
	movwf NEWAMTH
	movf PLAY0L,0
	movwf NEWAMTL
	clrf BYTETMP	;use of "dogsbody" variable
	movf NEWAMFL,0	;move lower byte to working register
	bsf STATUS,0	;clear carry indicator
	subwf NEWAMTL,0	;subtract lower byte
	btfsc STATUS,0	;check for overflow
	goto hbchk
	decf NEWAMTH,1	;decrement higher byte
	bcf STATUS,2
	movlw %11111111
	xorwf NEWAMTH,0
	btfss STATUS,2	;
	goto hbchk
	bsf BYTETMP,1	;set marker
hbchk:	movf NEWAMFH,0	;move higher byte to working register
	bsf STATUS,0	;clear carry indicator
	subwf NEWAMTH,0	;subtract higher byte
	btfss STATUS,0	;check for overflow
	bsf BYTETMP,1	;set marker
	btfss BYTETMP,1	;
	RETURN
	call MSG5
	clrf NEWAMFL
	clrf NEWAMFH
	clrf NEWAMTL
	clrf NEWAMTH
	clrf CLKOUT
OVRBP:	incf CLKOUT,1
	btfsc CLKOUT,5
	goto OVREN
	call BEEP
	goto OVRBP
OVREN:	call MSG2
	RETURN


add0:	btfsc BYTETMP,1	;
	RETURN
	movf NEWAMFL,0	;move lower byte to working register
	bcf STATUS,0	;clear carry indicator
	addwf PLAY0L,0	;add lower byte
	btfsc STATUS,0	;check for overflow
	incf PLAY0H,1	;increment higher byte
	movwf PLAY0L	;store lower byte result
	movf PLAY0H,0	;move higher byte to working register
	addwf NEWAMFH,0	;add higher byte
	movwf PLAY0H	;store higher byte result
	RETURN
add1:	btfsc BYTETMP,1	;
	RETURN
	movf NEWAMFL,0	;move lower byte to working register
	bcf STATUS,0	;clear carry indicator
	addwf PLAY1L,0	;add lower byte
	btfsc STATUS,0	;check for overflow
	incf PLAY1H,1	;increment higher byte
	movwf PLAY1L	;store lower byte result
	movf PLAY1H,0	;move higher byte to working register
	addwf NEWAMFH,0	;add higher byte
	movwf PLAY1H	;store higher byte result
	RETURN
add2:	btfsc BYTETMP,1	;
	RETURN
	movf NEWAMFL,0	;move lower byte to working register
	bcf STATUS,0	;clear carry indicator
	addwf PLAY2L,0	;add lower byte
	btfsc STATUS,0	;check for overflow
	incf PLAY2H,1	;increment higher byte
	movwf PLAY2L	;store lower byte result
	movf PLAY2H,0	;move higher byte to working register
	addwf NEWAMFH,0	;add higher byte
	movwf PLAY2H	;store higher byte result
	RETURN
add3:	btfsc BYTETMP,1	;
	RETURN
	movf NEWAMFL,0	;move lower byte to working register
	bcf STATUS,0	;clear carry indicator
	addwf PLAY3L,0	;add lower byte
	btfsc STATUS,0	;check for overflow
	incf PLAY3H,1	;increment higher byte
	movwf PLAY3L	;store lower byte result
	movf PLAY3H,0	;move higher byte to working register
	addwf NEWAMFH,0	;add higher byte
	movwf PLAY3H	;store higher byte result
	RETURN
add4:	btfsc BYTETMP,1	;
	RETURN
	movf NEWAMFL,0	;move lower byte to working register
	bcf STATUS,0	;clear carry indicator
	addwf PLAY4L,0	;add lower byte
	btfsc STATUS,0	;check for overflow
	incf PLAY4H,1	;increment higher byte
	movwf PLAY4L	;store lower byte result
	movf PLAY4H,0	;move higher byte to working register
	addwf NEWAMFH,0	;add higher byte
	movwf PLAY4H	;store higher byte result
	RETURN

sub0:	call TRCHK
	movf NEWAMFL,0	;move lower byte to working register
	bsf STATUS,0	;clear carry indicator
	subwf PLAY0L,0	;add lower byte
	btfss STATUS,0	;check for overflow
	decf PLAY0H,1	;increment higher byte
	movwf PLAY0L	;store lower byte result
	movf NEWAMFH,0	;move higher byte to working register
	subwf PLAY0H,1	;add higher byte
	RETURN
sub1:	movf NEWAMFL,0	;move lower byte to working register
	bsf STATUS,0	;clear carry indicator
	subwf PLAY1L,0	;add lower byte
	btfss STATUS,0	;check for overflow
	decf PLAY1H,1	;increment higher byte
	movwf PLAY1L	;store lower byte result
	movf NEWAMFH,0	;move higher byte to working register
	subwf PLAY1H,1	;add higher byte
	RETURN
sub2:	movf NEWAMFL,0	;move lower byte to working register
	bsf STATUS,0	;clear carry indicator
	subwf PLAY2L,0	;add lower byte
	btfss STATUS,0	;check for overflow
	decf PLAY2H,1	;increment higher byte
	movwf PLAY2L	;store lower byte result
	movf NEWAMFH,0	;move higher byte to working register
	subwf PLAY2H,1	;add higher byte
	RETURN
sub3:	movf NEWAMFL,0	;move lower byte to working register
	bsf STATUS,0	;clear carry indicator
	subwf PLAY3L,0	;add lower byte
	btfss STATUS,0	;check for overflow
	decf PLAY3H,1	;increment higher byte
	movwf PLAY3L	;store lower byte result
	movf NEWAMFH,0	;move higher byte to working register
	subwf PLAY3H,1	;add higher byte
	RETURN
sub4:	movf NEWAMFL,0	;move lower byte to working register
	bsf STATUS,0	;clear carry indicator
	subwf PLAY4L,0	;add lower byte
	btfss STATUS,0	;check for overflow
	decf PLAY4H,1	;increment higher byte
	movwf PLAY4L	;store lower byte result
	movf NEWAMFH,0	;move higher byte to working register
	subwf PLAY4H,1	;add higher byte
	RETURN

;-------TRANSACTION AMOUNT ACCUMULATION ROUTINES

Tadd:	movf NEWAM,0	;move digit to working register
	bcf STATUS,0	;clear carry indicator
	addwf NEWAMFL,1 ;add the digit in the working register to the low byte of the final transaction value
	btfsc STATUS,0  ;check for carry
	incf NEWAMFH,1	;and increment high byte if necessary
	RETURN

TxTEN:	call TxTWO	;multiply by two
	movf NEWAMFH,0	;keep a note of the result in temporary variables
	movwf NEWAMTH
	movf NEWAMFL,0	;keep a note of the result in temporary variables
	movwf NEWAMTL
	call TxTWO	;multiply by two twice more, now multipied by 8 overall
	call TxTWO
	movf NEWAMTL,0	;note that at this point NEWAMFL should still be in w anyway, this instruction for clarity only
	bcf STATUS,0	;clear carry indicator
	addwf NEWAMFL,1 ;add the digit in the working register to the low byte of the final transaction value
	btfsc STATUS,0  ;check for carry
	incf NEWAMFH,1	;and increment high byte if necessary
	movf NEWAMTH,0	;move the result from x2 high byte to w
	addwf NEWAMFH,1	;adding the high byte gets the final result
	RETURN

TxTWO:	bcf STATUS,0	;clear carry indicator
	rlf NEWAMFL,1	;shift left once, multiplying by two
	rlf NEWAMFH,1	;shift left once, multiplying by two, LSB is taken from STATUS,0
	RETURN

;----------------------LCD MESSAGES--------------------------------------

MSG1:	movlw %00000000
	movwf cursor
	CALL XCUR
	movlw 'R'
	call XSEND
	movlw 'e'
	call XSEND
	movlw 's'
	call XSEND
	movlw 'e'
	call XSEND
	movlw 'r'
	call XSEND
	movlw 'v'
	call XSEND
	movlw 'e'
	call XSEND
	movlw ':'
	call XSEND
	movlw ' '
	call XSEND
	movlw '$'
	call XSEND
	movlw ' '
	call XSEND
	movlw ' '
	call XSEND
	movlw ' '
	call XSEND
	movlw ' '
	call XSEND
	movlw ' '
	call XSEND
	RETURN

MSG2:	movlw %01000000
	movwf cursor
	CALL XCUR
	movlw 'P'
	call XSEND
	movlw 'l'
	call XSEND
	movlw 'a'
	call XSEND
	movlw 'y'
	call XSEND
	movlw 'e'
	call XSEND
	movlw 'r'
	call XSEND
	movlw ':'
	call XSEND
	movlw ' '
	call XSEND
	movlw ' '
	call XSEND
	movlw '$'
	call XSEND
	movlw ' '
	call XSEND
	movlw ' '
	call XSEND
	movlw ' '
	call XSEND
	movlw ' '
	call XSEND
	movlw ' '
	call XSEND
	movlw ' '
	call XSEND
	RETURN

MSG3:	movlw %00000000
	movwf cursor
	CALL XCUR
	movlw '*'
	call XSEND
	movlw ' '
	call XSEND
	movlw 'c'
	call XSEND
	movlw 'a'
	call XSEND
	movlw 'n'
	call XSEND
	movlw 'c'
	call XSEND
	movlw 'e'
	call XSEND
	movlw 'l'
	call XSEND
	movlw ' '
	call XSEND
	movlw '#'
	call XSEND
	movlw ' '
	call XSEND
	movlw 's'
	call XSEND
	movlw 'e'
	call XSEND
	movlw 'n'
	call XSEND
	movlw 'd'
	call XSEND
	movlw ' '
	call XSEND
	RETURN

MSG4:	movlw %01000000
	movwf cursor
	CALL XCUR
	movlw 'S'
	call XSEND
	movlw 'e'
	call XSEND
	movlw 'n'
	call XSEND
	movlw 'd'
	call XSEND
	movlw ' '
	call XSEND
	movlw ' '
	call XSEND
	movlw ' '
	call XSEND
	movlw ' '
	call XSEND
	movlw ' '
	call XSEND
	movlw '$'
	call XSEND
	movlw ' '
	call XSEND
	movlw ' '
	call XSEND
	movlw ' '
	call XSEND
	movlw ' '
	call XSEND
	movlw ' '
	call XSEND
	movlw ' '
	call XSEND
	RETURN

MSG5:	movlw %01000000
	movwf cursor
	CALL XCUR
	movlw '*'
	call XSEND
	movlw ' '
	call XSEND
	movlw ' '
	call XSEND
	movlw 'O'
	call XSEND
	movlw 'V'
	call XSEND
	movlw 'E'
	call XSEND
	movlw 'R'
	call XSEND
	movlw 'D'
	call XSEND
	movlw 'R'
	call XSEND
	movlw 'A'
	call XSEND
	movlw 'W'
	call XSEND
	movlw 'N'
	call XSEND
	movlw '!'
	call XSEND
	movlw ' '
	call XSEND
	movlw '*'
	call XSEND
	movlw ' '
	call XSEND
	RETURN

MSGA:	movlw %00000000
	movwf cursor
	CALL XCUR
	movlw 'D'
	call XSEND
	movlw 'a'
	call XSEND
	movlw 'v'
	call XSEND
	movlw 'e'
	call XSEND
	movlw ' '
	call XSEND
	movlw 'G'
	call XSEND
	movlw 'e'
	call XSEND
	movlw 'a'
	call XSEND
	movlw 'r'
	call XSEND
	movlw 'y'
	call XSEND
	movlw ' '
	call XSEND
	movlw '2'
	call XSEND
	movlw '0'
	call XSEND
	movlw '0'
	call XSEND
	movlw '7'
	call XSEND
	movlw ' '
	call XSEND
	RETURN

MSGB:	movlw %01000000
	movwf cursor
	CALL XCUR
	movlw 'B'
	call XSEND
	movlw 'a'
	call XSEND
	movlw 'n'
	call XSEND
	movlw 'k'
	call XSEND
	movlw 'e'
	call XSEND
	movlw 'r'
	call XSEND
	movlw ' '
	call XSEND
	movlw 'V'
	call XSEND
	movlw '1'
	call XSEND
	movlw '.'
	call XSEND
	movlw '0'
	call XSEND
	movlw '6'
	call XSEND
	movlw 'H'
	call XSEND
	movlw ' '
	call XSEND
	movlw ' '
	call XSEND
	movlw ' '
	call XSEND
	RETURN

;-------LCD DRIVER------------

XINIT:	CALL p10ms
	CALL XCMDMD	;Set to command mode
	CALL p10ms
	;Set 4 bit mode.
	bcf PORTB,5	;mod
	bcf PORTB,3
	bcf PORTB,2
	bsf PORTB,1
	bcf PORTB,0
	CALL XSEND8
	CALL p10ms

	;Initialise Display by sending 0011XXXX three times
	movlw %00110000
	movwf LCDOUT
	CALL XSEND4
	CALL p10ms
	movlw %00110000
	movwf LCDOUT
	CALL XSEND4
	CALL p10ms
	movlw %00110000
	movwf LCDOUT
	CALL XSEND4
	CALL p10ms
	movlw %00001110 	;sets display on and cursor
	movwf LCDOUT
	CALL XSEND4
	CALL p10ms

XCLR:	movlw %00000010		;cursor home
	movwf LCDOUT
	CALL XSEND4
	CALL p10ms
	movlw %00000001		;clear display
	movwf LCDOUT
	CALL XSEND4
	CALL p10ms
	;set character count variable
	;CALL XCLRST
	;Set to character mode
	CALL XCHRMD
	clrf FLAG
	RETURN

XNUM:	movwf LCDOUT
	bcf LCDOUT,7		;modify binary numbers to match LCD character map
	bcf LCDOUT,6
	bsf LCDOUT,5
	bsf LCDOUT,4
	GOTO XSEND4		;and then on to "normal" LCD SEND routine
	RETURN

XSEND:	movwf LCDOUT
XNUMC:	decfsz LCDCHR,1	;
	GOTO XSRST
	CALL XCLRST
XSRST:	CALL XSEND4
	RETURN

XCLRST:	movlw %00101000	;40 characters per line
	movwf LCDCHR
	bsf FLAG,0
	RETURN	

;-------SUBROUTINES------------

XSEND8:	CALL p1
	bsf PORTB,4	;mod
	CALL p1
	bcf PORTB,4	;mod
	CALL p40
	RETURN

XSEND4:	CALL p10ms
	swapf LCDOUT,0	;swap nibbles and move data byte to be sent to working register
	;swap nibbles
	ANDLW %00001111	;mask off top nibble
	CALL XCLRB
	movwf LCDWKG
	btfsc LCDWKG,0
	bsf PORTB,3
	btfsc LCDWKG,1
	bsf PORTB,2
	btfsc LCDWKG,2
	bsf PORTB,1	
	btfsc LCDWKG,3
	bsf PORTB,0
	CALL XSEND8
	CALL p10ms
	movf LCDOUT,0	;move data byte to be sent to working register
	ANDLW %00001111	;mask top nibble
	CALL XCLRB
	movwf LCDWKG
	btfsc LCDWKG,0
	bsf PORTB,3
	btfsc LCDWKG,1
	bsf PORTB,2
	btfsc LCDWKG,2
	bsf PORTB,1	
	btfsc LCDWKG,3
	bsf PORTB,0	
	CALL XSEND8
	CALL p10ms
	;CALL p10ms
	clrf LCDOUT
	RETURN
	
XCHRMD:	bsf PORTB,5	;mod
	CALL p10ms
	RETURN

XCMDMD:	bcf PORTB,5	;mod
	CALL p10ms
	RETURN

XCLRB:	bcf PORTB,0
	bcf PORTB,1
	bcf PORTB,2
	bcf PORTB,3
	RETURN


;----------------------------CURSOR POSITION-------------------------------------

XCUR:	CALL XCMDMD
	movf cursor,0
	MOVWF LCDOUT
	bsf LCDOUT,7
	CALL XSEND4
	CALL XCHRMD
	RETURN

;----------------------------BEEP ROUTINE-------------------------------------

BEEP:	bsf PORTA,0
	clrf BYTETMP
BEEPL:	btfsc BYTETMP,5
	goto BEEPEN
	call DLY
	incf BYTETMP,1
	goto BEEPL
BEEPEN:	bcf PORTA,0
	RETURN

;----------------------------TIMING SECTION-------------------------------------

p1:	nop
	nop
	RETURN		;at clock speeds below 4Mhz, instruction cycles take at least 1us anyway

p40:	clrf TMR0	;clear Timer 0 register
p40c:	btfsc TMR0,2	;
	RETURN		;
	GOTO p40c	;loop around again as necessary

p10ms:	clrf LCDWKG
p10msa:	btfss TMR0,2
	incf LCDWKG,1
p10msb:	btfsc TMR0,2
	goto p10msb
	btfss LCDWKG,7
	goto p10msa
	RETURN

DLY:	clrf TMR0
DLYL:	btfss TMR0,3
	goto DLYL
	RETURN

;-----------BINARY TO DECIMAL CONVERSION (ACK: PETER HEMSLEY WWW.EPEMAG.WIMBORNE.CO.UK)

B2DF:	movf	NUMHI,w		;Hex Digit 0X00 (H2)
	iorlw	0xF0		;w=H2-16
	movwf	D0		;D0=H2-16
	movwf	D1		;D1=H2-16
	addwf	D1,1		;D1=H2*2-32
	addwf	D1,1		;D1=H2*3-48, C=1
	movwf	D2		;D2=H2-16
	rlf	D2,1		;D2=H2*2-31

	swapf	NUMHI,w		;Hex Digit X000 (H3)
	iorlw	0xF0		;w=H3-16
	addwf	D2,1		;D2=H3+H2*2-47 Done!
	movwf	D3		;D3=H3-16
	addwf	D3,1		;D3=H3*2-32
	addlw	D'52'		;w=H3+36
	addwf	D0,1		;D0=H3+H2+20

	swapf	NUMLO,w		;Hex Digit 00X0 (H1)
	iorlw	0xF0		;w=H1-16
	addwf	D1,1		;D1=H2*3+H1-64
	addwf	D0,1		;D0=H3+H2+H1+4, C=1
	rlf	D0,1		;D0=(H3+H2+H1)*2+9, C=0
	comf	D0,1		;D0=-(H3+H2+H1)*2-10
	rlf	D0,1		;D0=-(H3+H2+H1)*4-20

	movf	NUMLO,w		;Hex Digit 000X (H0)
	andlw	0x0F		;w=H0
	addwf	D0,1		;D0=H0-(H3+H2+H1)*4-20 Done!
	rlf	D1,1		;C=0, D1=H2*6+H1*2-128 Done!

	movlw	D'7'
	movwf	D4		;D4=7

	addlw	D'3'		;w=10, C=0
	rlf	D3,1		;D3=H3*4-64 Done!
mod0
	addwf	D0,1		;D(X)=D(X)mod10
	decf	D1,1		;D(X+1)=D(X+1)+D(X)div10
	skpc
	goto	mod0
mod1
	addwf	D1,1
	decf	D2,1
	skpc
	goto	mod1
mod2
	addwf	D2,1
	decf	D3,1
	skpc
	goto	mod2
mod3
	addwf	D3,1
	decf	D4,1
	skpc
	goto	mod3

	return

.END
      	.END            ;final statement